@extends('admin.layouts.master')

@section('extra_css')
    <link rel="stylesheet" href="/assets/plugins/redactor/redactor.css"/>
@stop

@section('extra_js')
    <script src="/assets/plugins/redactor/plugins/imagemanager.js" data-cfasync='false'></script>
    <script src="/assets/plugins/redactor/redactor.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#description').redactor({
                imageUpload: '/admin/redactor',
                imageManagerJson: '/admin/redactor/images.json',
                plugins: ['imagemanager'],
                replaceDivs: false,
                convertDivs: false,
                uploadImageFields: {
                    _token: "{{csrf_token()}}"
                }
            });

            $('#{{\App\Posts::COMMENT_DISQUS}}_div').hide();

            $('#comment_system').on('change', function () {
                $selected = $('#comment_system option:selected').val();


                if ($selected == "{{\App\Posts::COMMENT_FACEBOOK}}") {
                    $('#{{\App\Posts::COMMENT_FACEBOOK}}_div').show();

                    $('#{{\App\Posts::COMMENT_DISQUS}}_div').hide();

                }

                if ($selected == "{{\App\Posts::COMMENT_DISQUS}}") {
                    $('#{{\App\Posts::COMMENT_DISQUS}}_div').show();

                    $('#{{\App\Posts::COMMENT_FACEBOOK}}_div').hide();

                }

            });

            $('#comment_system').trigger('change');

        });
    </script>
@stop

@section('content')

    <h3 class="page-title">
        Settings
        <small>Manage Settings</small>
    </h3>

    <div class="page-bar">
        <ul class="page-breadcrumb">

            <li>
                <a href="/admin">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="/admin/settings">Settings</a>
            </li>
        </ul>
    </div>

    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN PORTLET-->
            <div class="portlet box green-meadow">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings"></i>Change Settings
                    </div>
                    <div class="tools">
                        <a href="javascript:;" class="collapse">
                        </a>
                    </div>
                </div>

                <div class="portlet-body">

                    @include('admin.layouts.notify')

                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab_general" data-toggle="tab">
                                General </a>
                        </li>
                        <li>
                            <a href="#tab_seo" data-toggle="tab">
                                SEO </a>
                        </li>
                        <li>
                            <a href="#tab_comments" data-toggle="tab">
                                Comments </a>
                        </li>
                        <li>
                            <a href="#tab_social" data-toggle="tab">
                                Social </a>
                        </li>
                        <li>
                            <a href="#tab_custom_js" data-toggle="tab">
                                Custom Javascript </a>
                        </li>

                        <li>
                            <a href="#tab_custom_css" data-toggle="tab">
                                Custom CSS </a>
                        </li>
                    </ul>

                    <div class="tab-content">

                        <div class="tab-pane fade active in" id="tab_general">

                            <div class="row">
                                <div class="col-md-12">

                                    <form action="/admin/settings/update_general" id="form-username" method="post"
                                          class="form-horizontal form-bordered" enctype="multipart/form-data">

                                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>

                                        <div class="form-group">
                                            <label for="site_url" class="col-sm-3 control-label">Site URL</label>

                                            <div class="col-sm-8">
                                                <input id="site_url" class="form-control" type="text" name="site_url"
                                                       placeholder="{{URL::to('/')}}"
                                                       value="{{old('site_url',isset($settings['general']->site_url)?$settings['general']->site_url->value_string:'')}}"/>
                                                <span class="help-block"> Site URL should start with http:// or https://</span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="site_title" class="col-sm-3 control-label">Site Title</label>

                                            <div class="col-sm-8">
                                                <input id="site_title" class="form-control" type="text"
                                                       name="site_title"
                                                       placeholder="Enter Site title"
                                                       value="{{old('site_title',isset($settings['general']->site_title)?$settings['general']->site_title->value_string:'')}}"/>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="analytics_code" class="col-sm-3 control-label">Google Analytics
                                                Code</label>

                                            <div class="col-sm-8">
                                <textarea id="analytics_code" class="form-control" name="analytics_code"
                                          placeholder="Enter Google Analytics Code">{{old('analytics_code',isset($settings['general']->analytics_code)?$settings['general']->analytics_code->value_txt:'')}}</textarea>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="mailchimp_form" class="col-sm-3 control-label">Mailchimp Signup
                                                Form</label>

                                            <div class="col-sm-8">
                                <textarea id="mailchimp_form" class="form-control" name="mailchimp_form"
                                          placeholder="Enter Mailchimp Signup Form Code ">{{old('mailchimp_form',isset($settings['general']->mailchimp_form)?$settings['general']->mailchimp_form->value_txt:'')}}</textarea>
                                                <span class="help-block"> Know more about mailchimp signup form <a
                                                            href="http://kb.mailchimp.com/lists/signup-forms/add-a-signup-form-to-your-website">here</a></span>
                                            </div>

                                        </div>

                                        <div class="form-group">
                                            <label for="logo_76" class="col-sm-3 control-label">Logo 76x76</label>

                                            <div class="col-sm-8">
                                                <input id="logo_76" class="form-control" name="logo_76" type="file"/>
                                            </div>
                                        </div>

                                        @if($settings['general']->logo_76 && strlen($settings['general']->logo_76->value_string)>0)
                                            <div class="form-group">
                                                <div class="col-md-offset-3 col-md-8">
                                                    <input type="hidden" name="logo_76_value"
                                                           value="{{$settings['general']->logo_76->value_string}}"/>
                                                    <img src="{{$settings['general']->logo_76->value_string}}"/>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="form-group">
                                            <label for="logo_120" class="col-sm-3 control-label">Logo 120x120</label>

                                            <div class="col-sm-8">
                                                <input id="logo_120" class="form-control" name="logo_120" type="file"/>
                                            </div>
                                        </div>

                                        @if($settings['general']->logo_120 && strlen($settings['general']->logo_120->value_string)>0)
                                            <div class="form-group">
                                                <div class="col-md-offset-3 col-md-8">
                                                    <input type="hidden" name="logo_120_value"
                                                           value="{{$settings['general']->logo_120->value_string}}"/>
                                                    <img src="{{$settings['general']->logo_120->value_string}}"/>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="form-group">
                                            <label for="logo_152" class="col-sm-3 control-label">Logo 152x152</label>

                                            <div class="col-sm-8">
                                                <input id="logo_152" class="form-control" name="logo_152" type="file"/>
                                            </div>
                                        </div>

                                        @if($settings['general']->logo_152 && strlen($settings['general']->logo_152->value_string)>0)
                                            <div class="form-group">
                                                <div class="col-md-offset-3 col-md-8">
                                                    <input type="hidden" name="logo_152_value"
                                                           value="{{$settings['general']->logo_152->value_string}}"/>
                                                    <img src="{{$settings['general']->logo_152->value_string}}"/>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="form-group">
                                            <label for="favicon" class="col-sm-3 control-label">Upload favicon</label>

                                            <div class="col-sm-8">
                                                <input type="hidden" name="favicon_value"
                                                       value="{{isset($settings['general']->favicon)?$settings['general']->favicon->value_string:''}}"/>
                                                <input id="favicon" class="form-control" name="favicon" type="file"/>
                                            </div>
                                        </div>

                                        @if(isset($settings['general']->favicon) && strlen($settings['general']->favicon->value_string)>0)
                                            <div class="form-group">
                                                <div class="col-md-offset-3 col-md-8">
                                                    <img src="{{$settings['general']->favicon->value_string}}"/>
                                                </div>
                                            </div>
                                        @endif


                                        <div class="form-group">
                                            <div class="col-md-offset-3 col-md-8">
                                                <div class="checkbox">
                                                    <label>
                                                        <input {{(isset($settings['general']->site_post_as_articles)&&$settings['general']->site_post_as_articles->value_check == 1)?'checked':''}}
                                                               name="site_post_as_articles" type="checkbox"> Use Post
                                                        Title as Site title on post pages </label>
                                                </div>
                                                <span class="help-block"> If checked post article will be used as page title on post detail pages</span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="col-md-offset-3 col-md-8">
                                                <div class="checkbox">
                                                    <label>
                                                        <input {{(isset($settings['general']->generate_sitemap)&&$settings['general']->generate_sitemap->value_check == 1)?'checked':''}}
                                                               name="generate_sitemap" type="checkbox"> Generate
                                                        Sitemap
                                                        ? </label>
                                                </div>
                                                <span class="help-block"> If checked sitemap will be generated at {{URL::to('/').'/sitemap.xml'}}</span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="col-md-offset-3 col-md-8">
                                                <div class="checkbox">
                                                    <label>
                                                        <input {{(isset($settings['general']->generate_rss_feeds)&&$settings['general']->generate_rss_feeds->value_check == 1)?'checked':''}}
                                                               name="generate_rss_feeds" type="checkbox"> Generate RSS
                                                        Feeds ? </label>
                                                </div>
                                                <span class="help-block"> If checked RSS url will be {{URL::to('/').'/rss.xml'}}</span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="col-md-offset-3 col-md-8">
                                                <div class="checkbox">
                                                    <label>
                                                        <input {{(isset($settings['general']->include_sources)&&$settings['general']->include_sources->value_check == 1)?'checked':''}}
                                                               name="include_sources" type="checkbox"> Include posts
                                                        from sources in rss feeds ? </label>
                                                </div>
                                                <span class="help-block"> If checked all posts will be included in rss feeds</span>
                                            </div>
                                        </div>

                                        <div class="form-actions">
                                            <div class="row">
                                                <div class="col-md-offset-3 col-md-9">
                                                    <button type="submit" class="btn purple"><i class="fa fa-check"></i>
                                                        Save
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane fade" id="tab_seo">
                            <div class="row">
                                <div class="col-md-12">

                                    <form action="/admin/settings/update_seo" id="form-username" method="post"
                                          class="form-horizontal form-bordered">

                                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>

                                        <div class="form-group">
                                            <label for="seo_keywords" class="col-sm-3 control-label">SEO
                                                Keywords</label>

                                            <div class="col-sm-8">
                                <textarea id="seo_keywords" class="form-control" name="seo_keywords"
                                          placeholder="Enter SEO Keywords">{{old('seo_keywords',isset($settings['seo']->seo_keywords)?$settings['seo']->seo_keywords->value_txt:'')}}</textarea>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="seo_description" class="col-sm-3 control-label">SEO
                                                Description</label>

                                            <div class="col-sm-8">
                                <textarea id="seo_description" class="form-control" name="seo_description"
                                          placeholder="Enter SEO Description">{{old('seo_description',isset($settings['seo']->seo_description)?$settings['seo']->seo_description->value_txt:'')}}</textarea>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="google_verify" class="col-sm-3 control-label">Google Webmaster
                                                Domain Verify</label>

                                            <div class="col-sm-8">
                                                <input id="google_verify" class="form-control" type="text"
                                                       name="google_verify"
                                                       placeholder="Paste your meta tag here to verify your website on google webmasters"
                                                       value="{{old('google_verify',isset($settings['seo']->google_verify)?$settings['seo']->google_verify->value_string:'')}}"/>
                                                <span class="help-block"> Paste your meta tag here to verify your website on google webmasters , it will look something like below</span>
                                                <label class="label label-success">&#x3C;meta name=&#x22;google-site-verification&#x22;
                                                    content=&#x22;QsHIQMfsdaassq1kr8irG33KS7LoaJhZY8XLTdAQ7PA&#x22; /&#x3E;</label>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="bing_verify" class="col-sm-3 control-label">Bing Webmaster
                                                Domain Verify</label>

                                            <div class="col-sm-8">
                                                <input id="bing_verify" class="form-control" type="text"
                                                       name="bing_verify"
                                                       placeholder="Paste your meta tag here to verify your website on bing webmasters"
                                                       value="{{old('bing_verify',isset($settings['seo']->bing_verify)?$settings['seo']->bing_verify->value_string:'')}}"/>
                                                <span class="help-block"> Paste your meta tag here to verify your website on bing webmasters , it will look something like below</span>
                                                <label class="label label-success">&#x3C;meta name=&#x22;msvalidate.01&#x22;
                                                    content=&#x22;5A3A378F55B7518E3733ffS784711DC0&#x22; /&#x3E;</label>
                                            </div>
                                        </div>

                                        <div class="form-actions">
                                            <div class="row">
                                                <div class="col-md-offset-3 col-md-9">
                                                    <button type="submit" class="btn purple"><i class="fa fa-check"></i>
                                                        Save
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="tab_comments">

                            <div class="row">
                                <div class="col-md-12">

                                    <form action="/admin/settings/update_comments" id="form-username" method="post"
                                          class="form-horizontal form-bordered" enctype="multipart/form-data">

                                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>

                                        <div class="form-group">
                                            <label for="comment_system" class="col-sm-3 control-label">Select Commenting
                                                System</label>

                                            <div class="col-sm-8">
                                                <select class="form-control" id="comment_system" name="comment_system">

                                                    <option {{(isset($settings['comments']->comment_system)&&$settings['comments']->comment_system->value_string == \App\Posts::COMMENT_FACEBOOK)?'selected':''}}
                                                            value="{{\App\Posts::COMMENT_FACEBOOK}}">Facebook
                                                    </option>
                                                    <option {{(isset($settings['comments']->comment_system)&&$settings['comments']->comment_system->value_string == \App\Posts::COMMENT_DISQUS)?'selected':''}}
                                                            value="{{\App\Posts::COMMENT_DISQUS}}">Disqus
                                                    </option>
                                                </select>
                                            </div>
                                        </div>

                                        <div id="{{\App\Posts::COMMENT_FACEBOOK}}_div">

                                            <div class="form-group">
                                                <label for="fb_js" class="col-sm-3 control-label">Facebook Commenting
                                                    Javascript Code</label>

                                                <div class="col-sm-8">
                                <textarea id="fb_js" class="form-control" name="fb_js"
                                          placeholder="Paste Facebook Javascript Code">{{old('fb_js',isset($settings['comments']->fb_js)?$settings['comments']->fb_js->value_txt:'')}}</textarea>
                                                    <span class="help-block"><a
                                                                href="https://developers.facebook.com/docs/plugins/comments#code-generator">Click
                                                            here</a> for more info on facebook commenting system</span>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label for="fb_num_posts" class="col-sm-3 control-label">Number of
                                                    Posts</label>

                                                <div class="col-sm-8">
                                                    <input type="text" id="fb_num_posts" class="form-control"
                                                           name="fb_num_posts"
                                                           placeholder="Enter no of commenting posts to display"
                                                           value="{{old('fb_num_posts',isset($settings['comments']->fb_num_posts)?$settings['comments']->fb_num_posts->value_string:'')}}"/>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <div class="col-md-offset-3 col-md-8">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input {{(isset($settings['comments']->fb_comment_count)&&$settings['comments']->fb_comment_count->value_check == 1)?'checked':''}}
                                                                   name="fb_comment_count" type="checkbox"> Show
                                                            comment
                                                            count
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>

                                        <div id="{{\App\Posts::COMMENT_DISQUS}}_div">

                                            <div class="form-group">
                                                <label for="disqus_js" class="col-sm-3 control-label">Disqus Javascript
                                                    Code</label>

                                                <div class="col-sm-8">
                                <textarea id="disqus_js" class="form-control" name="disqus_js"
                                          placeholder="Paste Disqus Javascript Code">{{old('disqus_js',isset($settings['comments']->disqus_js)?$settings['comments']->disqus_js->value_txt:'')}}</textarea>
                                                    <span class="help-block">If show comment count is checked you should also include disqus comment count js in above box , <a
                                                                href=""> Click
                                                            here</a> for more info on disqus commenting system</span>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <div class="col-md-offset-3 col-md-8">
                                                    <div class="checkbox">
                                                        <label>
                                                            <input {{(isset($settings['comments']->disqus_comment_count)&&$settings['comments']->disqus_comment_count->value_check == 1) ?'checked':'' }}
                                                                   name="disqus_comment_count" type="checkbox"> Show
                                                            comment count
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="form-group">
                                            <div class="col-md-offset-3 col-md-8">
                                                <div class="checkbox">
                                                    <label>
                                                        <input {{(isset($settings['comments']->show_comment_box)&&$settings['comments']->show_comment_box->value_check == 1) ?'checked':'' }}
                                                               name="show_comment_box" type="checkbox"> Show comment
                                                        box
                                                    </label>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="form-actions">
                                            <div class="row">
                                                <div class="col-md-offset-3 col-md-9">
                                                    <button type="submit" class="btn purple"><i class="fa fa-check"></i>
                                                        Save
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane fade" id="tab_social">

                            <div class="row">
                                <div class="col-md-12">

                                    <form action="/admin/settings/update_social" id="form-username" method="post"
                                          class="form-horizontal form-bordered" enctype="multipart/form-data">

                                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>

                                        <div class="form-group">
                                            <label for="fb_page_url" class="col-sm-3 control-label">Facebook Page
                                                URL</label>

                                            <div class="col-sm-8">
                                                <input id="fb_page_url" class="form-control" type="text"
                                                       name="fb_page_url"
                                                       placeholder="Enter facebook page url"
                                                       value="{{old('fb_page_url',isset($settings['social']->fb_page_url->value_string)?$settings['social']->fb_page_url->value_string:'')}}"/>
                                                <span class="help-block"> URL should start with http:// or https://</span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="twitter_url" class="col-sm-3 control-label">Twitter URL</label>

                                            <div class="col-sm-8">
                                                <input id="twitter_url" class="form-control" type="text"
                                                       name="twitter_url"
                                                       placeholder="Enter twitter url"
                                                       value="{{old('twitter_url',isset($settings['social']->twitter_url->value_string)?$settings['social']->twitter_url->value_string:'')}}"/>
                                                <span class="help-block"> URL should start with http:// or https://</span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="twitter_handle" class="col-sm-3 control-label">Twitter Handle</label>

                                            <div class="col-sm-8">
                                                <input id="twitter_handle" class="form-control" type="text"
                                                       name="twitter_handle"
                                                       placeholder="Enter twitter handle @kode_info"
                                                       value="{{old('twitter_handle',isset($settings['social']->twitter_handle->value_string)?$settings['social']->twitter_handle->value_string:'')}}"/>
                                                <span class="help-block"> Handle should start with @</span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="google_plus_page_url" class="col-sm-3 control-label">Google Page
                                                URL</label>

                                            <div class="col-sm-8">
                                                <input id="google_plus_page_url" class="form-control" type="text"
                                                       name="google_plus_page_url"
                                                       placeholder="Enter google plus page url"
                                                       value="{{old('google_plus_page_url',isset($settings['social']->google_plus_page_url->value_string)?$settings['social']->google_plus_page_url->value_string:'')}}"/>
                                                <span class="help-block"> URL should start with http:// or https://</span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="skype_username" class="col-sm-3 control-label">Skype
                                                Username</label>

                                            <div class="col-sm-8">
                                                <input id="skype_username" class="form-control" type="text"
                                                       name="skype_username"
                                                       placeholder="Enter skype username"
                                                       value="{{old('skype_username',isset($settings['social']->skype_username->value_string)?$settings['social']->skype_username->value_string:'')}}"/>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="youtube_channel_url" class="col-sm-3 control-label">Youtube
                                                Channel URL</label>

                                            <div class="col-sm-8">
                                                <input id="youtube_channel_url" class="form-control" type="text"
                                                       name="youtube_channel_url"
                                                       placeholder="Enter youtube channel url"
                                                       value="{{old('youtube_channel_url',isset($settings['social']->youtube_channel_url->value_string)?$settings['social']->youtube_channel_url->value_string:'')}}"/>
                                                <span class="help-block"> URL should start with http:// or https://</span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="vimeo_channel_url" class="col-sm-3 control-label">Vimeo Channel
                                                URL</label>

                                            <div class="col-sm-8">
                                                <input id="vimeo_channel_url" class="form-control" type="text"
                                                       name="vimeo_channel_url"
                                                       placeholder="Enter vimeo channel url"
                                                       value="{{old('vimeo_channel_url',isset($settings['social']->vimeo_channel_url->value_string)?$settings['social']->vimeo_channel_url->value_string:'')}}"/>
                                                <span class="help-block"> URL should start with http:// or https://</span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="addthis_js" class="col-sm-3 control-label">AddThis Javascript
                                                Code</label>

                                            <div class="col-sm-8">
                                                <textarea id="addthis_js" class="form-control" name="addthis_js"
                                                          placeholder="Paste AddThis Javascript code">{{old('addthis_js',isset($settings['social']->addthis_js->value_txt)?$settings['social']->addthis_js->value_txt:'')}}</textarea>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="sharethis_js" class="col-sm-3 control-label">ShareThis
                                                Span Tags
                                            </label>

                                            <div class="col-sm-8">
                                                <textarea id="sharethis_span_tags" class="form-control"
                                                          name="sharethis_span_tags"
                                                          placeholder="Paste ShareThis Span Tags">{{old('sharethis_span_tags',isset($settings['social']->sharethis_span_tags->value_txt)?$settings['social']->sharethis_span_tags->value_txt:'')}}</textarea>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="sharethis_js" class="col-sm-3 control-label">ShareThis
                                                Javascript Code</label>

                                            <div class="col-sm-8">
                                                <textarea id="sharethis_js" class="form-control" name="sharethis_js"
                                                          placeholder="Paste ShareThis Javascript code">{{old('sharethis_js',isset($settings['social']->sharethis_js->value_txt)?$settings['social']->sharethis_js->value_txt:'')}}</textarea>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="facebook_box_js" class="col-sm-3 control-label">Facebook Box HTML and
                                                Javascript Code</label>

                                            <div class="col-sm-8">
                                                <textarea id="facebook_box_js" class="form-control"
                                                          name="facebook_box_js"
                                                          placeholder="Paste Facebook Box Javascript Code">{{old('facebook_box_js',isset($settings['social']->facebook_box_js->value_txt)?$settings['social']->facebook_box_js->value_txt:'')}}</textarea>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="twitter_box_js" class="col-sm-3 control-label">Twitter Box HTML and
                                                Javascript Code</label>

                                            <div class="col-sm-8">
                                                <textarea id="twitter_box_js" class="form-control" name="twitter_box_js"
                                                          placeholder="Paste Twitter Box Javascript Code">{{old('twitter_box_js',isset($settings['social']->twitter_box_js->value_txt)?$settings['social']->twitter_box_js->value_txt:'')}}</textarea>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="col-md-offset-3 col-md-8">
                                                <div class="checkbox">
                                                    <label>
                                                        <input {{(isset($settings['social']->show_sharing)&&$settings['social']->show_sharing->value_check == 1)?'checked':''}}
                                                               name="show_sharing" type="checkbox"> Show sharing on
                                                        posts
                                                    </label>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="form-actions">
                                            <div class="row">
                                                <div class="col-md-offset-3 col-md-9">
                                                    <button type="submit" class="btn purple"><i class="fa fa-check"></i>
                                                        Save
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane fade" id="tab_custom_js">

                            <div class="row">
                                <div class="col-md-12">

                                    <form action="/admin/settings/update_custom_js" id="form-username" method="post"
                                          class="form-horizontal form-bordered">

                                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>

                                        <div class="form-group">
                                            <label for="custom_js" class="col-sm-3 control-label">Custom Javascript
                                                Code</label>

                                            <div class="col-sm-8">
                                                <textarea rows="10" cols="10" id="custom_js" class="form-control"
                                                          name="custom_js"
                                                          placeholder="Custom Javascript Code">{{isset($settings['custom_js']->custom_js)?$settings['custom_js']->custom_js->value_txt:''}}</textarea>
                                            </div>
                                        </div>

                                        <div class="form-actions">
                                            <div class="row">
                                                <div class="col-md-offset-3 col-md-9">
                                                    <button type="submit" class="btn purple"><i class="fa fa-check"></i>
                                                        Save
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane fade" id="tab_custom_css">

                            <div class="row">
                                <div class="col-md-12">

                                    <form action="/admin/settings/update_custom_css" id="form-username" method="post"
                                          class="form-horizontal form-bordered">

                                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>

                                        <div class="form-group">
                                            <label for="custom_css" class="col-sm-3 control-label">Custom CSS
                                                Code</label>

                                            <div class="col-sm-8">
                                                <textarea rows="10" cols="10" id="custom_css" class="form-control"
                                                          name="custom_css"
                                                          placeholder="Custom CSS Code">{{isset($settings['custom_css']->custom_css)?$settings['custom_css']->custom_css->value_txt:''}}</textarea>
                                            </div>
                                        </div>

                                        <div class="form-actions">
                                            <div class="row">
                                                <div class="col-md-offset-3 col-md-9">
                                                    <button type="submit" class="btn purple"><i class="fa fa-check"></i>
                                                        Save
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </div>

                    </div>
                </div>
            </div>
            <!-- END PORTLET-->
        </div>
    </div>
@stop